import { applyTimeOffset } from "./app/SimpleTimekeeping";

export class CalendarClass extends CONFIG.time.worldCalendarClass {
    timeToComponents(...args) {
        const components = super.timeToComponents(...args);
        const startingWeekday = CONFIG.time.worldCalendarConfig.months.values[components.month].startingWeekday ?? null;
        if (Number.isFinite(startingWeekday)) {
            components.dayOfWeek = (components.dayOfMonth + startingWeekday) % this.days.values.length;
        }
        return components;
    }
}